<?php
/* Copyright (C) 2004-2018  Laurent Destailleur     <eldy@users.sourceforge.net>
 * Copyright (C) 2018-2019  Nicolas ZABOURI         <info@inovea-conseil.com>
 * Copyright (C) 2019-2020  Frédéric France         <frederic.france@netlogic.fr>
 * Copyright (C) 2021-2022	Clément Da-Purificaçao	<clement@code42.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

/**
 *     \defgroup   landingpage     Module LandingPage
 *  \brief      LandingPage module descriptor.
 *
 *  \file       htdocs/landingpage/core/modules/modLandingPage.class.php
 *  \ingroup    landingpage
 *  \brief      Description and activation file for module LandingPage
 */
require_once DOL_DOCUMENT_ROOT.'/core/modules/DolibarrModules.class.php';

/**
 *  Description and activation class for module LandingPage
 */
class modLandingPage extends DolibarrModules
{
    /**
     * Constructor. Define names, constants, directories, boxes, permissions
     *
     * @param DoliDB $db Database handler
     */
    public function __construct($db)
    {
        global $langs, $conf;
        $this->db = $db;

        $this->numero = 448512;
        $this->rights_class = 'landingpage';
        $this->family = "Code 42";
        $this->module_position = '90';
        $this->name = preg_replace('/^mod/i', '', get_class($this));
        $this->description = "LandingPageDescription";
        $this->descriptionlong = "LandingPage description (Long)";
        $this->editor_name = 'Code 42';
        $this->editor_url = 'https://www.code42.fr';
        $this->version = '13.0.03';
        $this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
        $this->picto = 'landingpage@landingpage';
        $this->module_parts = array(
        'triggers' => 0,
        'login' => 0,
        'substitutions' => 0,
        'menus' => 0,
        'tpl' => 0,
        'barcode' => 0,
        'models' => 0,
        'theme' => 0,
        'css' => array(
        '/landingpage/css/landingpage.css.php',
        ),
        'js' => array(
        ),
        'hooks' => array(
                   'data' => array(
                       'main',
					   'h2g2',
                   ),
        ),
        'moduleforexternal' => 0,
        );
        $this->dirs = array("/landingpage/temp");
        $this->config_page_url = array("setup.php@landingpage");
        $this->hidden = false;
        $this->depends = array();
        $this->requiredby = array();
        $this->conflictwith = array();
		$this->langfiles = array("landingpage@landingpage");
        $this->phpmin = array(5, 5);
        $this->need_dolibarr_version = array(10, 0);
        $this->warnings_activation = array();
        $this->warnings_activation_ext = array();
        $this->const = array();

        if (!isset($conf->landingpage) || !isset($conf->landingpage->enabled)) {
            $conf->landingpage = new stdClass();
            $conf->landingpage->enabled = 0;
        }

        $this->tabs = array();
        $this->dictionaries = array();
        $this->boxes = array();
        $this->cronjobs = array();
    }

    /**
     *  Function called when module is enabled.
     *  The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
     *  It also creates data directories
     *
     * @param  string $options Options when enabling module ('', 'noboxes')
     * @return int                 1 if OK, 0 if KO
     */
    public function init($options = '')
    {
        global $conf, $langs;

        // Permissions
        $this->remove($options);

        $sql = array();

        return $this->_init($sql, $options);
    }

    /**
     *  Function called when module is disabled.
     *  Remove from database constants, boxes and permissions from Dolibarr database.
     *  Data directories are not deleted
     *
     * @param  string $options Options when enabling module ('', 'noboxes')
     * @return int                 1 if OK, 0 if KO
     */
    public function remove($options = '')
    {
        $sql = array();
        return $this->_remove($sql, $options);
    }
}
